//+------------------------------------------------------------------+
//|  Close all                                             close.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"
#property show_confirm

int   slippage=3; 

int start()
{
   bool   result;
   double price;
   int    cmd,error;
   string str=""; 
   int count, total, i ; 
   int   OrderList[]; 
   
   if ( Digits == 3 || Digits == 5  ) //  5 digit broker
   {
     slippage = slippage*10;  
   }

   int  PendingOrders[12]= {-1,-1,-1,-1,-1,-1} ; 
   int  OpenOrders[12]= {-1,-1,-1,-1,-1,-1 } ; 
       
   double pri ; 
   int z = 0;
   int y=0; 

   total  = OrdersTotal();

   string sym = Symbol();
   
   for ( i = 0; i< total; i++ )
   {
      OrderSelect(i, SELECT_BY_POS, MODE_TRADES);
   
      if(    OrderType()>= OP_BUYLIMIT  && OrderSymbol() == sym   ) //  close pending orders 
  	   {
         PendingOrders[z] = OrderTicket();
         z = z+1; 
  	   }
  	   else 	if(  OrderType() <= OP_SELL  && OrderSymbol() == sym    ) //  close open orders 
  	   {
         OpenOrders[y] = OrderTicket();
         y = y+1; 
  	   }
   }           // end of loop 

   if ( z > 0 || y > 0 )
      Print("Found " + y + " open orders");
      
   // now close or delete them

   for ( i = 0; i<z ; i++ )
   {
      if ( PendingOrders[i] >= 0 )
      {
         result = OrderSelect(PendingOrders[i], SELECT_BY_TICKET, MODE_TRADES);
         if ( result == false ) Print("Select Pending Failed " + GetLastError()); 
         if ( PendingOrders[i] >= 0 ) OrderDelete(  PendingOrders[i] ,CLR_NONE);
      }
   }

   for ( i = 0; i< y ; i++ )
   {
     RefreshRates();
     
     if ( OpenOrders[i] >= 0 ) 
     {
         result = OrderSelect(OpenOrders[i], SELECT_BY_TICKET, MODE_TRADES);
         if ( result == false ) Print("Select Open Failed " + GetLastError());
         
         if ( OrderType() == OP_SELL )   pri =  Ask ; 
  	      else if ( OrderType() == OP_BUY )  pri =  Bid ; 
         RepeatCloseOrder( OpenOrders[i], OrderLots() , pri , slippage , Red  );
         Print("Tried to close one order");
     }
     
  }
  

   return(0);
}



bool  RepeatCloseOrder( int ticket, double lots,  double price, double slippage, color arrow_color   )
{
      bool succeed=false;
      int err=0;
      int c = 0;
      int Attempts = 100;
      
      for(c = Attempts ; c >= 0; c--)
      {
            //HealthCheck(); // check to make sure EA is running correctly
            RefreshRates();
            succeed=OrderClose(ticket ,lots,price,slippage, arrow_color);
            int magic=OrderMagicNumber();
            
            if (succeed == false) 
            {
                string symbol = OrderSymbol();
                Print("CloseOrder Failed for Symbol: " + symbol + " Ticket: " + ticket + " Price: " + price + 
                " Lots: " + lots + " Slippage: " + slippage + 
                " Magic Number: " + magic +  " Color : " + arrow_color );
                
               
                err=GetLastError();
                
                if ( err!=0)
                {
                    if( err==2 || err==4 ||err==6 || err==8 || err==9 || err==64 || err==128 || err==132 || err==133 || err==137 || err==139 || err==141 || err==146)
                    { //Sleep and retry errors
                       if(IsTesting()==false) Sleep(50);
                       continue;
                    }
                    if(err==135 || err==136 )
                    { // price change errors
                       Print ("******** Invalid Price " + price + " ********");
                       start();//restart and make sure that new price meets our entry criteria
                       break;
                    }
                    if(err==138 )
                    { // Requote
                       Print ("******** REQUOTE PRICE ERROR " +  price + " ********");
                       start();//restart and make sure that new price meets our entry criteria
                       break;
                    }
                    else
                    { // other errors
                       break;
                    }
                 }
             }
             break;
      }
      
      return (ticket);
}  


